<?php

namespace App\Modules\Secretariat\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Meeting extends Model 
{

    protected $table = 'meetings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'employee_id', 'meeting_date', 'meeting_room_id', 'type', 'note', 'status');

    public function employees()
    {
        return $this->belongsToMany('App\Modules\HR\Entities\Employee');
    }

    public function meetingRoom()
    {
        return $this->belongsTo('App\Modules\Secretariat\Entities\MeetingRoom');
    }

    public function MeetingDiscussionPoint()
    {
        return $this->hasMany('App\Modules\Secretariat\Entities\MeetingDiscussionPoint');
    }

    public function meetingDecisions()
    {
        return $this->hasMany('App\Modules\Secretariat\Entities\MeetingDecision');
    }

}